//======================================================
// CharaMake.js
//======================================================

/*:ja
*  @plugindesc 簡易キャラメイクプラグイン
*  @author BomberBreak
*
*  @param StartSwNo
*  @desc キャラメイクスタートSw
*  @default 120
*
*
*  @help
* 
* Plugin Command:
*  CharaMake TVファイル名 TVファイル内参照インデックス値 SVファイル名 データベース内の職業ID
* ※TVファイル名　 TVファイル内参照インデックス値　はFaceと同じであること
*/

 (function()
 {
 	var parameters = PluginManager.parameters('CharaMake');
 	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
 	
 	var intStartSwitcNo = parameters['StartSwNo'] || 120;//120番からスタート
 	
 	Game_Interpreter.prototype.pluginCommand = function(command, args)
 	{
 	
 		//処理内容の分岐
 		_Game_Interpreter_pluginCommand.call(this, command, args);
		if(command === "CharaMake")
		{
			CharaMake(this, args);
		}
		else if(command === "CharaDelete")
		{
			CharaDelete(this, args);
		}
 	}
 	
 	/*=====================================================
 			キャラメイク
 	  =====================================================*/
 	function CharaMake( objPtr, args)
 	{
 		
 		var strTvReadFileName = args[0];					//TVファイル名（Faceファイル名と連動）
		var intFileIndex = Number(args[1]);					//ファイル内のインデックス番号（Faceのインデックスと連動）
			
		var strSvReadFileName = args[2];					//SVファイル名
		var intDBJobID = Number(args[3]);					//DBの職業ID
		//var strName = args[4];							//名前
		
		var isNewMakeOk = false;							//作成可能フラグ
		var isMakeActorID;									//作成できるactorID
		
		var i;
		
		
		for(i = 2; i < 21; i++)
		{
			//スイッチが１つでもfalseならメイク可能
			if( $gameSwitches.value(intStartSwitcNo + i ) == false )
			{
				isNewMakeOk = true;
				break;
			}
		}
		
		//作れるが来たとき
		if( isNewMakeOk )
		{
			$gameActors.actor(i).setName($dataClasses[intDBJobID].name + i );
			SceneManager.push(Scene_Name);
			SceneManager.prepareNextScene(i, 6);
			objPtr.setWaitMode('message');

			$gameActors.actor(i).changeClass(intDBJobID);
			
			$gameActors.actor(i).setFaceImage(strTvReadFileName, intFileIndex);				//Faceキャラ
			//アクターの変更を行う処理を使う
			$gameActors.actor(i).setCharacterImage(strTvReadFileName, intFileIndex);		//TVキャラ
			$gameActors.actor(i).setBattlerImage(strSvReadFileName);						//SVキャラ
			 
			$gamePlayer.refresh();															//更新処理
			
			$gameMessage.add($gameActors._data[i]._name + "生产！");
			$gameParty.addActor(i);															//そのキャラを即追加
			
			$gameSwitches.setValue(intStartSwitcNo + i, true );
		}
		else
		{
			$gameMessage.add("要创建的角色太多");
		}
 	}
 	/*=====================================================
 			キャラ削除
 	  =====================================================*/
 	  function CharaDelete(objPtr, args)
 	  {
 	  	var isDelOk = false;								//作成可能フラグ
		
		var NameArry = new Array();							//名前検索
		var IndexArray = new Array();						//名前番号
		var SaveIndex = 0;									//登録Index
		
 	  	//データが存在するか確認と配列に取り込み
		for (i = 2; i < $gameActors._data.length; i++)
		{
			//switchがONになっていれば作成されている
			if ( $gameSwitches.value(intStartSwitcNo + i ) == true )
			{
				isDelOk = true;
				
				//配列にしまう
				NameArry.push($gameActors._data[i]._name);			//ゲームアクター名取得
				IndexArray.push(i);									//その番号取得
			}
		}
		objPtr.wait(1);
	
		//誰か作ってある場合
		if( isDelOk )
		{
			var SentakusiMake = '';
			for(i = 0; i < NameArry.length; i++)
			{
				SentakusiMake += '"' + NameArry[i] + '"';
				
				if(NameArry.length != i)
				{
					SentakusiMake += ',';
				}
			}
			
			SentakusiMake += '"やめる"';
			alert(SentakusiMake);
			objPtr.setupChoices( [ [ SentakusiMake ], NameArry.length + 1, 0, 2, 0] );
			//objPtr.setupChoices( [ [ ], NameArry.length + 1, 0, 2, 0] );
			var SelectIndex = objPtr._branch[this._indent];
			alert("選択番号>" + SelectIndex);
			
			objPtr.setWaitMode('message');
			
			
			
		}
		else
		{
			$gameMessage.add("キャラがいません。");
		}
		
 	  }
 	  
 
 })();
